---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- To run, open SQL Plus and TYPE 
-- In NT: @d:\ddl_main5.sql
-- Where d:\ is the path of where you placed this file
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: 
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Renamed file ddl_main.sql	-> ddl_main5.sql
-- MSW 092700 Renamed file ddl_tables.sql -> ddl_tabl5.sql
-- MSW 092700 Renamed file ddl_procs.sql  -> ddl_proc5.sql
-- MSW 092700 Renamed file ddl_data.sql	-> ddl_data5.sql
-- MSW 092700 Added file 			-> ddl_test5.sql, Contains "TEST" data
-- MSW 092700 Added file 			-> ddl_extr5.sql, Contains extra DDL that doesn't fit other categories
-- MSW 100500 Split ddl_proc5.sql into 5 files _> ddl_pkg_user5.sql, ddl_pkg_eval5.sql, ddl_pkg_reco5.sql, ddl_pkg_clus5.sql, ddl_pkg_sear5.sql
-- MSW 100500 Added alkindi_index TABLESPACE
-- MSW 100500 Added sq_USER_CLUSTER_ID SEQUENCE
-- MSW 100600 Added file 			-> ddl_pkg_calc.sql, Contains recalcs stats package


---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CONNECTION
---------------------------------------------------------------------------------------------------------

CONN system/manager
DROP USER alkindi CASCADE;

CREATE TABLESPACE alkindi PERMANENT
	DATAFILE 'tabspace_alkindi_1.dat' SIZE 20M 
	DEFAULT STORAGE (INITIAL	10K
				NEXT		50K 	
				MINEXTENTS 	1
				MAXEXTENTS 	999) 
	ONLINE; 

CREATE TABLESPACE alkindi_index PERMANENT
	DATAFILE 'tabspace_alkindi_Ind_1.dat' SIZE 20 M
	DEFAULT STORAGE  (INITIAL	50K
				NEXT		50K
				MINEXTENTS	2
				MAXEXTENTS	50)
	ONLINE;


CREATE USER alkindi IDENTIFIED BY password;

GRANT CONNECT, RESOURCE TO alkindi -- [RC] Connect, Resource instead of DBA;

alter user alkindi default tablespace alkindi temporary tablespace temp;
-- [RC] tablespaces alkindi, alkindi_index and temp instead of the default (system)

CONN alkindi/password;
-- conn alkindi/password@dev -- [RC];

---------------------------------------------------------------------------------------------------------
-- END CONNECTION
---------------------------------------------------------------------------------------------------------


---------------------------------------------------------------------------------------------------------
-- BEGIN SEQUENCE CREATION
---------------------------------------------------------------------------------------------------------
CREATE SEQUENCE sq_USER_ID 		INCREMENT BY 1 START WITH 1000000 	NOMAXVALUE NOCYCLE CACHE 100 ORDER;

CREATE SEQUENCE sq_PRODUCT_ID 	INCREMENT BY 1 START WITH 1000000 	NOMAXVALUE NOCYCLE CACHE 100 ORDER;

CREATE SEQUENCE sq_USER_CLUSTER_ID 	INCREMENT BY 1 START WITH 1		NOMAXVALUE NOCYCLE CACHE 100 ORDER;
---------------------------------------------------------------------------------------------------------
-- END SEQUENCE CREATION
---------------------------------------------------------------------------------------------------------

@/home/AlkAdmin/ddl/_1006b/ddl_tabl5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_user5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_eval5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_reco5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_clus5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_sear5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_extr5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_pkg_calc5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_data5.sql;
@/home/AlkAdmin/ddl/_1006b/ddl_test5.sql;

COMMIT;

